


export class NoteEditPopup {
	
	tpl = `
		<div class="page-header">
			<div class="toolbox">
				<a href="javascript:void(0)" [onclick]="widget.close" class="fa fa-times-circle"></a>
				
				<span ez-if="isNew == false && writable">
					<a href="javascript:void(0);" [onclick]="widget.deleteNote" class="fa fa-trash"></a>
				</span>
				
				<span ez-if="loading == false && writable">
					<a href="javascript:void(0);" [onclick]="widget.saveNote" class="fa fa-save"></a>
				</span>
			</div>
			<h1>{{isNew?'Nieuwe notitie':'Bewerk notitie'}}</h1>
		</div>

		<div ez-if="loading == true">Loading...</div>
		
		<div ez-if="loading == false">
			<form id="frmNote">
				<ez-checkbox name="important" label="Belangrijk" [checked]="note.important"></ez-checkbox>
				
				<ez-text name="shortNote" label="Titel" [value]="note.shortNote"></ez-text>
				
				<ez-textarea name="longNote" label="Notitie" [value]="note.longNote"></ez-text>
			</form>
		</div>
	`;
	
	
	refObject = null;
	refId = null;
	
	loading = false;
	
	isNew = true;
	note = {
		noteId: null,
		shortNote: '',
		longNote: '',
		important: 0
	};
	
	container = null;
	
	writable = true;
	
	callback_save = null;
	
	
	setRefObject(o) { this.refObject = o; }
	setRefId(i) { this.refId = i; }
	setWritable(bln) { this.writable = bln ? true : false; }
	
	setNoteId( id ) { this.note.noteId = id; }
	
	setNote(n) {
		this.note = n;
		this.isNew = false;
	}
	
	setCallbackSave( c ) { this.callback_save = c; }
	
	
	saveNote() {
		if (this.writable == false)
			return;
		
		if (this.validate() > 0)
			return;
		
		showLoadingForm('#frmNote');
		
		let frm = $('#frmNote');
		
		let data = {};
		data.a = 'save';
		data.refObject = this.refObject;
		data.refId = this.refId;
		
		data.noteId = this.note.noteId;
		data.important = frm.find('input[name=important]').prop('checked') ? 1 : 0;
		data.shortNote = frm.find('input[name=shortNote]').val();
		data.longNote = frm.find('textarea[name=longNote]').val();
		
		
		postUrl( '/service/notes.do', data ).then( async function(e) {
			let json = await e.json();
			if (this.callback_save) {
				this.callback_save( this.address, this );
			}
			
			close_popup();
			
			showToastMessage('Notitie opgeslagen');
		}.bind(this) );
	}
	
	validate() {
		this.note.shortNote = $.trim( $('#frmNote input[name=shortNote]').val() );
		this.note.longNote  = $('#frmNote input[name=longNote]').val();
		this.note.important = $('#frmNote input[name=important]').prop( 'checked' );
		

		let errorCount = 0;
		$(this.container).find('span.error').text( '' );
		
		if (this.note.shortNote == '') {
			$('#frmNote [name=shortNote] .error').text('verplicht');
			errorCount++;
		}
		
		return errorCount;
	}
	
	
	close() {
		close_popup();
	}
	
	
	loadNote(noteId) {
		this.loading = true;
		
		postUrl('/service/notes.do', {
			a: 'view',
			noteId: noteId
		}).then( async function(e) {
		let json = await e.json();
//			console.log('json', json);
			
			this.isNew = false;
			this.loading = false;
			this.note = json.note;
			this.render();
			
			if (this.writable == false) {
				$(this.container).find('input, textarea').attr('readonly', 'readonly');
				$(this.container).find('input[type=checkbox]').attr('disabled', 'disabled');
			}
			
		}.bind(this));
	}
	
	deleteNote() {
		showConfirmation('Verwijder', 'Weet je zeker dat je deze notitie wilt verwijderen?', function() {
			showLoadingForm('#frmNote');
			
			postUrl( '/service/notes.do', {
				a: 'delete',
				noteId: this.note.noteId
			}).then( async function(e) {
				let json = await e.json();
				if (this.callback_save) {
					this.callback_save( this.address, this );
				}
				
				close_popup();
				
				showToastMessage('Notitie verwijderd');
			}.bind(this) );
			
		}.bind(this));
	}
	
	render() {
		if (!this.container)
			this.container = show_popup('Notitie', '');
		
		let ezTpl = new EzTemplate( this.container );
		ezTpl.loadHtml( this.tpl );
		ezTpl.setVar('loading', this.loading);
		ezTpl.setVar('note', this.note);
		ezTpl.setVar('isNew', this.isNew);
		ezTpl.setVar('writable', this.writable);
		ezTpl.setObject('widget', this);
		ezTpl.render();
		
		
		focusFirstField('#frmNote');
	}
	
	showPopup() {
		this.render();
	}
	
	
}

